(function() {
  var Bridge, CSI, check, fsEnabled, getBackgroundColor, getBackgroundHex, getThemeClass, menuEvent, menuXML, onAppThemeColorChanged, onDocumentLoaded, onMenuClick, persistent, ready, themeChangeEvent, tick, updateSessionInfo;

  CSI = new CSInterface();

  Bridge = null;

  themeChangeEvent = CSInterface.THEME_COLOR_CHANGED_EVENT;

  menuEvent = "com.adobe.csxs.events.flyoutMenuClicked";

  menuXML = function() {
    return "<Menu>\n  <MenuItem Id=\"version\" Label=\"GuideGuide " + (Bridge.guideguideVersion()) + (Bridge.freeVersion() ? ' (free)' : '') + "\" Enabled=\"false\" Checked=\"false\"/>\n  <MenuItem Label=\"---\" />\n  <MenuItem Id=\"tracking\" Label=\"Tracking settings\" Enabled=\"true\" Checked=\"false\"/>\n  " + (Bridge.freeVersion() ? '<MenuItem Id=\"buy\" Label=\"Buy GuideGuide\" Enabled=\"true\" Checked=\"false\"/>' : '') + "\n</Menu>";
  };

  persistent = function() {
    var csInterface, event, id;
    event = new CSEvent('com.adobe.PhotoshopPersistent', 'APPLICATION');
    id = "com.cameronmcefee.guideguide";
    event.extensionId = id;
    csInterface = new CSInterface();
    return csInterface.dispatchEvent(event);
  };

  updateSessionInfo = function() {
    return Bridge.fetchAndSyncDocumentInfo();
  };

  getThemeClass = function() {
    var color;
    color = getBackgroundColor();
    if (color._r < 64) {
      return 'theme-darker';
    }
    if (color._r < 128) {
      return 'theme-dark';
    }
    if (color._r < 192) {
      return 'theme-light';
    }
    return 'theme-lighter';
  };

  getBackgroundColor = function() {
    var color;
    color = JSON.parse(window.__adobe_cep__.getHostEnvironment()).appSkinInfo.panelBackgroundColor.color;
    return tinycolor("rgba(" + color.red + "," + color.green + "," + color.blue + "," + color.alpha + ")");
  };

  getBackgroundHex = function() {
    return getBackgroundColor().toHexString();
  };

  fsEnabled = function() {
    var fs;
    fs = window.cep.fs;
    if (fs == null) {
      return false;
    }
    if (fs.showOpenDialog == null) {
      return false;
    }
    if (fs.readFile == null) {
      return false;
    }
    if (fs.showSaveDialogEx == null) {
      return false;
    }
    if (fs.writeFile == null) {
      return false;
    }
    return true;
  };

  check = function() {
    Bridge = document.getElementById('panel').contentWindow.Bridge;
    if (Bridge && Bridge.ready) {
      return ready();
    } else {
      return tick();
    }
  };

  tick = function() {
    return setTimeout(check, 50);
  };

  ready = function() {
    CSI.setPanelFlyoutMenu(menuXML());
    CSI.addEventListener('documentAfterActivate', updateSessionInfo);
    CSI.addEventListener('documentAfterDeactivate', updateSessionInfo);
    CSI.addEventListener(themeChangeEvent, onAppThemeColorChanged);
    CSI.addEventListener(menuEvent, onMenuClick);
    Bridge.exec = function(method, data, callback) {
      var methodStr;
      if (typeof arguments[1] === 'function') {
        callback = arguments[1];
        data = null;
      }
      methodStr = "$.GuideGuide." + method + "(" + (data ? '\'' + JSON.stringify(data) + '\'' : '') + ")";
      return CSI.evalScript(methodStr, function(result) {
        var json;
        json = typeof result === 'string' ? JSON.parse(result) : null;
        if (callback != null) {
          return callback(null, json);
        }
      });
    };
    Bridge.getLocale = function() {
      var env;
      env = JSON.parse(window.__adobe_cep__.getHostEnvironment());
      return env.appUILocale.toLowerCase();
    };
    Bridge.getAppVersion = function() {
      return "" + (CSI.getApplicationID()) + " " + (parseInt(CSI.getHostEnvironment().appVersion));
    };
    Bridge.fetchAndSyncAppInfo = function(callback) {
      var _this = this;
      return this.exec('getAppInfo', function(err, info) {
        info.themeClass = getThemeClass();
        info.locale = _this.getLocale();
        info.localStorage = window.localStorage != null;
        info.fsEnabled = fsEnabled();
        _this.syncAppInfo(info);
        if (callback) {
          return callback();
        }
      });
    };
    Bridge.getDocumentRulerUnits = function(callback) {
      return CSI.evalScript('$.GuideGuide.getDocumentRulerUnits()', callback);
    };
    Bridge.openUrl = function(url) {
      return CSI.openURLInDefaultBrowser(url);
    };
    Bridge.readFile = function(callback) {
      var file, result;
      result = window.cep.fs.showOpenDialog(false, false, 'open', null, ['json']);
      if (result.err) {
        return callback('fileError');
      }
      if (!/\.json$/gi.test(result.data[0])) {
        return callback('notJSON');
      }
      file = window.cep.fs.readFile(result.data[0]);
      if (file.err) {
        return callback('fileError');
      }
      return callback(null, file.data);
    };
    Bridge.writeFile = function(filename, data, callback) {
      var result, save, show, title;
      show = window.cep.fs.showSaveDialogEx;
      title = this.Messages.get('titleExportGrids');
      save = this.Messages.get('btnExport');
      result = show(title, null, ['json'], 'grids.json', null, save);
      if (result.data === '') {
        return callback('canceled');
      }
      result = window.cep.fs.writeFile(result.data, data);
      if (result.err) {
        return callback(result.err);
      }
      if (callback()) {
        return callback;
      }
    };
    return Bridge.fetchAndSyncAppInfo(function() {
      return Bridge.fetchAndSyncDocumentInfo(function() {
        Bridge.updateTheme();
        Bridge.start();
        document.getElementById('panel').style.opacity = 1;
        return persistent();
      });
    });
  };

  onAppThemeColorChanged = function(event) {
    Bridge.syncAppInfo({
      themeClass: getThemeClass()
    });
    return Bridge.updateTheme();
  };

  onMenuClick = function(event) {
    switch (event.data.menuId) {
      case 'tracking':
        return Bridge.changeTrackingSettings();
      case 'buy':
        return Bridge.openUrl('http://guideguide.me/');
    }
  };

  onDocumentLoaded = function() {
    var e, iframe;
    document.body.style.backgroundColor = getBackgroundHex();
    iframe = document.getElementById('panel');
    iframe.src = iframe.getAttribute('data-src');
    if (iframe.contentWindow.localStorage != null) {
      try {
        iframe.contentWindow.localStorage = {
          getItem: function() {
            return null;
          },
          setItem: function() {
            return null;
          },
          removeItem: function() {
            return null;
          }
        };
      } catch (_error) {
        e = _error;
      }
    }
    return tick();
  };

  document.addEventListener('DOMContentLoaded', onDocumentLoaded, false);

}).call(this);
